<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" indent="yes"/>
  
  <xsl:template match="/">
    <xsl:processing-instruction name="xml-stylesheet">
      <xsl:text>type="text/xsl" href="tocdisplay.xsl"</xsl:text>
    </xsl:processing-instruction>
    
    <toc>

      <xsl:for-each select="/namespacelist/namespace">
        <!-- for each file in the file list I will pull in
             namespace/class/pme/etc info -->
        
      <xsl:variable name="namespace" select="."/>

      <xsl:for-each select="document(concat('merged', '/', $namespace, '.xml'))/namespace">
        <xsl:if test="descendant::*[@publish='yes']">
          <namespace>
            <xsl:attribute name="name">
              <xsl:value-of select="$namespace"/>
            </xsl:attribute>
           
            <xsl:variable name = "classesnode">
              <xsl:for-each select="class[@publish='yes']">
                <xsl:variable name="class">
                  <xsl:value-of select="@name"/>
                </xsl:variable>
                
               <xsl:call-template name="getstructure">
                 <xsl:with-param name="namespace" select="$namespace"/>
                 <xsl:with-param name="class" select="$class"/>
               </xsl:call-template>
               
           </xsl:for-each>
    </xsl:variable>

    <xsl:for-each select="$classesnode/class">
    <xsl:sort select = "@name"/>
      <xsl:copy-of select="."/>
    </xsl:for-each>

      <xsl:variable name = "interfacesnode">
           <xsl:for-each select="interface[@publish='yes']">
             <xsl:variable name="interface">
               <xsl:value-of select="@name"/>
             </xsl:variable>
             <xsl:call-template name="interfacestructure">
               <xsl:with-param name="namespace" select="$namespace"/>
               <xsl:with-param name="interface" select="$interface"/>
             </xsl:call-template>
           </xsl:for-each>
    </xsl:variable>

    <xsl:for-each select="$interfacesnode/interface">
    <xsl:sort select="@name"/>
      <xsl:copy-of select="."/>
    </xsl:for-each>

    <xsl:variable name = "othersnode">
      <xsl:for-each select="constant[@publish='yes'] | const[@publish='yes'] | routine[@publish='yes'] | variable[@publish='yes'] | type[@publish='yes']">
        <xsl:variable name="other">
          <xsl:value-of select="@name"/>
        </xsl:variable>
        <xsl:call-template name="otherstructure">
          <xsl:with-param name="namespace" select="$namespace"/>
          <xsl:with-param name="object" select="$other"/>
        </xsl:call-template>
      </xsl:for-each>
    </xsl:variable>


    <xsl:for-each select="$othersnode/constant | $othersnode/const | $othersnode/routine | $othersnode/variable | $othersnode/type">
      <xsl:sort select="@name"/>
      <xsl:copy-of select="."/>
    </xsl:for-each>
    
  </namespace>
</xsl:if>

</xsl:for-each>
       
</xsl:for-each>
</toc>
</xsl:template>
  
  <!-- ######## getstructure ######## -->

  <xsl:template name="getstructure">
    <xsl:param name="namespace"/>
    <xsl:param name="class"/>

      <class>
        <xsl:attribute name="name">
          <xsl:value-of select="$class"/>
        </xsl:attribute>

        <xsl:if test="members/method[@publish='yes' and ./syntax/@variety='constructor']">
            <constructor>
              <xsl:value-of select="members/method[./syntax/@variety ='constructor']/@name"/>
            </constructor>
        </xsl:if>
        
        <properties>
      <xsl:variable name = "propertiesnode">
          <xsl:for-each select="members/property[@publish='yes' and not(@name=following-sibling::property/@name)]">
            <property>
              <xsl:value-of select="@name"/>
            </property>
          </xsl:for-each>
      </xsl:variable>
      
      <xsl:for-each select="$propertiesnode/property">
          <xsl:sort select="text()"/>
          <xsl:copy-of select="."/>
      </xsl:for-each>

        </properties>

        <methods>
      <xsl:variable name = "methodsnode">
          <xsl:for-each select="members/method[@publish='yes' and not(@name=following-sibling::method/@name) and not(@name=$class) and not (@name ='Create')]">
            <xsl:variable name="methcontentname" select="@name"/>
            <xsl:element name="method">
              <xsl:if test="count(syntax)&gt;1">
                <xsl:attribute name="overloaded">true</xsl:attribute>
              </xsl:if>
              <xsl:value-of select="@name"/>
            </xsl:element>
          </xsl:for-each>
      </xsl:variable>
      
      <xsl:for-each select="$methodsnode/method">
          <xsl:sort select="text()"/>
          <xsl:copy-of select="."/>
      </xsl:for-each>

        </methods>

        <events>
      <xsl:variable name = "eventsnode">
          <xsl:for-each select="members/event[@publish='yes']">
            <event>
              <xsl:value-of select="@name"/>
            </event>
          </xsl:for-each>
      </xsl:variable>
      
      <xsl:for-each select="$eventsnode/event">
          <xsl:sort select="text()"/>
          <xsl:copy-of select="."/>
      </xsl:for-each>

        </events>

        <xsl:if test="methodlinks/methodlink">
          <methodlinks haslinks="yes"/>          
        </xsl:if>
        <xsl:if test="propertylinks/propertylink">
          <propertylinks haslinks="yes"/>          
        </xsl:if>
        <xsl:if test="eventlinks/eventlink">
          <eventlinks haslinks="yes"/>          
        </xsl:if>

      </class>
    
  </xsl:template>

  <!-- ##### interfacestructure ##### -->
  <xsl:template name="interfacestructure">
    <xsl:param name="namespace"/>
    <xsl:param name="interface"/>
      <interface>
        <xsl:attribute name="name">
          <xsl:value-of select="$interface"/>
        </xsl:attribute>

        <!--
             <xsl:message>
               <xsl:copy-of select="."/>
             </xsl:message>
             -->

        <properties>
          <xsl:variable name="interfacepropertiesnode">
            <xsl:for-each select="./members/property[@publish='yes' and not(@name=following-sibling::property/@name)]">
              <property>
                <xsl:value-of select="@name"/>
              </property>
            </xsl:for-each>
          </xsl:variable>
      
          <xsl:for-each select="$interfacepropertiesnode/property">
            <xsl:sort select="text()"/>
            <xsl:copy-of select="."/>
          </xsl:for-each>

        </properties>
        
        <methods>

          <!-- 070103 SN updated to match above, allowing overloads -->
          <xsl:variable name="interfacemethodsnode">
            <xsl:for-each select="./members/method[@publish='yes' and not(@name=following-sibling::method/@name)]">
            <xsl:variable name="methcontentname" select="@name"/>
            <xsl:element name="method">
              <xsl:if test="count(syntax)&gt;1">
                <xsl:attribute name="overloaded">true</xsl:attribute>
              </xsl:if>
              <xsl:value-of select="@name"/>
            </xsl:element>
          </xsl:for-each>
      </xsl:variable>
      
      <xsl:for-each select="$interfacemethodsnode/method">
          <xsl:sort select="text()"/>
          <xsl:copy-of select="."/>
      </xsl:for-each>



        </methods>

        <events>
            <xsl:variable name="interfaceeventsnode">
            <xsl:for-each select="members/event[@publish='yes']">
                <event>
                    <xsl:value-of select="@name"/>
                </event>
            </xsl:for-each>
            
        </xsl:variable>
        
        <xsl:for-each select="$interfaceeventsnode/event">
            <xsl:sort select="text()"/>
            <xsl:copy-of select="."/>
        </xsl:for-each>

        </events>

        <xsl:if test="methodlinks/methodlink">
          <methodlinks haslinks="yes"/>          
        </xsl:if>
        <xsl:if test="propertylinks/propertylink">
          <propertylinks haslinks="yes"/>          
        </xsl:if>
        <xsl:if test="eventlinks/eventlink">
          <eventlinks haslinks="yes"/>          
        </xsl:if>

      </interface>

  </xsl:template>


  <!-- ##### otherstructure ##### -->
  <xsl:template name="otherstructure">
    <xsl:param name="namespace"/>
    <xsl:param name="object"/>
      
      <xsl:variable name="elementtype" select="name(.)"/>

      <xsl:element name="{$elementtype}">
        
        <xsl:attribute name="name">
          <xsl:value-of select="@name"/>
        </xsl:attribute>
        <xsl:copy-of select="@variety"/>

        <!-- leave struct fields and methods out of toc!
        <xsl:if test="@variety='struct'">
          <fields>
            <xsl:variable name="structfieldsnode">
              <xsl:for-each select="members/field[not(@name=following-sibling::field/@name)]">
                <field>
                  <xsl:value-of select="@name"/>
                </field>
              </xsl:for-each>
            </xsl:variable>

          <xsl:for-each select="$structfieldsnode/field">
            <xsl:sort select="text()"/>
            <xsl:copy-of select="."/>
          </xsl:for-each>
        </fields>
      </xsl:if>
      

        <xsl:if test="@variety='struct'">
        <methods>

          <xsl:variable name="structmethodsnode">
          <xsl:for-each select="members/method[not(@name=following-sibling::method/@name)]">
            <xsl:variable name="methcontentname" select="@name"/>
            <xsl:element name="method">
              <xsl:if test="count(syntax)&gt;1">
                <xsl:attribute name="overloaded">true</xsl:attribute>
              </xsl:if>
              <xsl:value-of select="@name"/>
            </xsl:element>
          </xsl:for-each>
        </xsl:variable>
      
        <xsl:for-each select="$structmethodsnode/method">
          <xsl:sort select="text()"/>
          <xsl:copy-of select="."/>
        </xsl:for-each>

        </methods>
      </xsl:if>
      -->
    </xsl:element>

  </xsl:template>


</xsl:stylesheet>




